# encoding: utf-8
from __future__ import unicode_literals

import logging

from collections import deque
from time import sleep

from logbroker_processors.processors import Processor
from .parsers import UserJournalParser
from logbroker_processors.utils import ClickhouseTSKVPusher

loger = logging.getLogger(__name__)


class ClickhouseProcessor(Processor):
    """Процессор UserJornal для сбора статистики по письмам"""

    def __init__(self, *args, **kwargs):
        super(ClickhouseProcessor, self).__init__(*args, **kwargs)
        self._parser = UserJournalParser()
        self._buffer = deque()
        self._pushers = [ClickhouseTSKVPusher(loger, **opts) for opts in kwargs['clickhouse']]

    def process(self, header, data):
        all_records = self._parser.parse(data)
        if not all_records:
            return False
        valid_records = [rec for rec in all_records if rec and rec.valid]
        if not valid_records:
            return False
        self._buffer.extend(valid_records)
        return True

    def _flush_pause(self):
        # Hack for enlarge clickhouse insert batch size
        # Fixes DB::Exception: Too much parts. Merges are processing significantly slower than inserts.
        sleep(10)

    def flush(self, force=False):
        loger.debug('Flushing %d records to database', len(self._buffer))
        if not force and len(self._buffer) < 100000:
            return

        for pusher in self._pushers:
            pusher.push(self._buffer)
        self._buffer.clear()
        self._flush_pause()
