import StringIO
import logging

log = logging.getLogger(__name__)


class Processor(object):
    """
    Abstract processor class designed to provide default processing functionality.
    The only external functions are process() and commit().

    Actual processors should inherit this class.

    Returns {
     data:   <actual data dict(), with keys cf-prepended>
     key:    <rowkey>
     cf:     <column family>
     table:  <table name>
    }
    """
    def __init__(self, *args, **kwargs):
        pass

    def split(self, chunk):
        lines = StringIO.StringIO(chunk)
        for line in lines:
            yield line

    def process(self, header, data):
        pass

    def flush(self, force=False):
        pass


class MockProcessor(Processor):
    def __init__(self, **opts):
        self.opts = opts
        self.accumulator = []
        self.meta_accumulator = []

    def process(self, header, data):
        self.accumulator.append(data)
        self.meta_accumulator.append(header)

    def flush(self, force=True):
        log.debug(self.opts)
        log.debug(self.accumulator)
        log.debug(self.meta_accumulator)
