# encoding: utf-8
from __future__ import unicode_literals

from datetime import datetime


class BaseRecord(object):
    def _make_tskv_value(self, name, value):
        if value is None or value == '':
            return None
        return '{}={}'.format(name, value)

    def _to_tskv(self):
        if not self._valid:
            raise ValueError("record is incorrect")
        parts = (
            'tskv\tdate={}'.format(self.date),
        )
        return '\t'.join((x for x in parts if x))

    @property
    def valid(self):
        return self._valid

    @property
    def tskv(self):
        return self._to_tskv() + '\n'


class DeliveryRecord(BaseRecord):

    def __init__(self,
                 unixtime=None,
                 channel=None,
                 recepient=None,
                 account=None,
                 campaign_id=None,
                 letter_code=None,
                 letter_id=None,
                 status=None,
                 for_testing='False',
                 **kwargs):
        self._valid = True
        if not unixtime or not channel or not recepient:
            self._valid = False
            return
        try:
            event_date = datetime.fromtimestamp(float(unixtime))
            self.date = event_date.strftime('%Y-%m-%d')
        except ValueError:
            self._valid = False
            return
        self.channel = channel
        self.recepient = recepient
        self.event_date = event_date.strftime('%Y-%m-%d %H:%M:%S')
        self.account = account
        self.campaign = int(campaign_id) if campaign_id and campaign_id.isdigit() else None
        self.letter = int(letter_id) if letter_id and letter_id.isdigit() else None
        self.letter_code = letter_code
        self.message_id = kwargs.get('message-id', '')
        self.status = int(status) if status else None
        self.test_letter = 1 if for_testing and for_testing == 'True' else 0

    def _to_tskv(self):
        parts = (
            super(DeliveryRecord, self)._to_tskv(),
            self._make_tskv_value('channel', self.channel),
            self._make_tskv_value('recepient', self.recepient),
            self._make_tskv_value('event_date', self.event_date),
            self._make_tskv_value('account', self.account),
            self._make_tskv_value('campaign', self.campaign),
            self._make_tskv_value('letter', self.letter),
            self._make_tskv_value('letter_code', self.letter_code),
            self._make_tskv_value('message_id', self.message_id),
            self._make_tskv_value('status', self.status),
            self._make_tskv_value('test_letter', self.test_letter),
        )
        return '\t'.join((x for x in parts if x))


class ClickRecord(BaseRecord):

    def __init__(self,
                 unixtime=None,
                 channel='email',
                 event=None,
                 event_type=None,
                 email=None,
                 campaign_id=None,
                 account=None,
                 letter_id=None,
                 link_number=None,
                 link_id=None,
                 link_url=None,
                 for_testing='False',
                 message_id='',
                 **kwargs):
        self._valid = True
        if not unixtime or not channel or not email:
            self._valid = False
            return
        try:
            event_date = datetime.fromtimestamp(float(unixtime))
            self.date = event_date.strftime('%Y-%m-%d')
        except ValueError:
            self._valid = False
            return
        self.channel = "email"
        self.recepient = email
        self.event = event
        self.event_type = event_type
        self.event_date = event_date.strftime('%Y-%m-%d %H:%M:%S')
        self.campaign = int(campaign_id) if campaign_id and campaign_id.isdigit() else None
        self.account = account
        self.letter = int(letter_id) if letter_id and letter_id.isdigit() else None
        self.link_id = link_id or link_number
        self.link_url = link_url
        self.test_letter = 1 if for_testing and for_testing == 'True' else 0
        self.message_id = message_id

    def _to_tskv(self):
        parts = (
            super(ClickRecord, self)._to_tskv(),
            self._make_tskv_value('channel', self.channel),
            self._make_tskv_value('recepient', self.recepient),
            self._make_tskv_value('event', self.event),
            self._make_tskv_value('event_type', self.event_type),
            self._make_tskv_value('event_date', self.event_date),
            self._make_tskv_value('campaign', self.campaign),
            self._make_tskv_value('account', self.account),
            self._make_tskv_value('letter', self.letter),
            self._make_tskv_value('link_id', self.link_id),
            self._make_tskv_value('link_url', self.link_url),
            self._make_tskv_value('test_letter', self.test_letter),
            self._make_tskv_value('message_id', self.message_id),
        )
        return '\t'.join((x for x in parts if x))
