# encoding: utf-8
from __future__ import unicode_literals

from .utils import retry_on
from .api import ResponseError, BaseAPI, APIConnectionError


class MetaMailError(ResponseError):
    pass


class MetaMailAPI(BaseAPI):
    @retry_on(APIConnectionError)
    def get_meta(self, uid, suid, mid, mdb=None):
        params = {'uid': uid, 'suid': suid, 'mids': mid}
        if mdb:
            params['mdb'] = mdb
            params['folder_set'] = 'default'
        result = self._make_request(params)

        if 'envelopes' not in result or len(result['envelopes']) == 0:
            raise MetaMailError('mail not found with params: "%s" response: "%s"' % (params, result))

        meta = result['envelopes'][0]

        try:
            return {
                'data': meta['date'],
                'stid': meta['stid']
            }
        except KeyError:
            raise MetaMailError('invalid response %s ' % result)
