# encoding: utf-8
import logging


def safe_decode(s):
    if isinstance(s, str):
        return s.decode('utf-8')

    return s


class ParseError(Exception):
    pass


class DataParser(object):
    required_fields = []
    exclude_fields = []

    def __init__(self, cfg):
        self._cfg = cfg

        self.cleaned_data = None
        self._raw_data = None

    def is_valid(self, data):
        self.cleaned_data = {}
        self._raw_data = data
        try:
            for field, value in data.iteritems():
                if field in self.exclude_fields:
                    continue

                value = safe_decode(value)
                clean_method = getattr(self, 'clean_{0}'.format(field), None)
                if clean_method and callable(clean_method):
                    self.cleaned_data[field] = clean_method(value)
                else:
                    self.cleaned_data[field] = value
            self.cleaned_data = self.clean()
        except ParseError:
            self.cleaned_data = None
            return False

        return True

    def clean(self):
        for field in self.required_fields:
            if field not in self.cleaned_data:
                logging.error(u"Invalid data format, field '%s' is missing", field)
                raise ParseError
        return self.cleaned_data
