"""
Actual processing logic is defined in ClickhouseLogProcessor.

For raw data converison rules, see "DDL" classes.

This module is for (sub)processor definitions only.
"""
from logbroker_processors.clickhouse import ClickhouseLogProcessor
from mdb_clickhouse_logs import ddl


class UserjournalClickhouse(ClickhouseLogProcessor):
    def __init__(self, **opts):
        super(UserjournalClickhouse, self).__init__(**opts)
        self.marker_field = 'tskv_format'
        self.processors = {
            'mail-user-journal-tskv-log': ddl.Userjournal(),
            'mail-user-journal-log': ddl.Userjournal(),
        }
