# encoding: utf-8
from __future__ import unicode_literals
from os import environ

import random
import requests

environ['REQUESTS_CA_BUNDLE'] = '/etc/ssl/certs/ca-certificates.crt'


class ClickhouseTSKVPusher(object):

    def __init__(self, logger, **opts):
        self.logger = logger
        self.__opts = opts
        self.__query = 'INSERT INTO {}.{} FORMAT TSKV'.format(self.__opts['database'], self.__opts['table_name'])
        self.__timeout = self.__opts.get('timeout', 5)
        self.__choose_host()

    def __choose_host(self):
        host = random.choice(self.__opts['hosts'])
        if self.__opts.get('user'):
            self.__url = 'https://{user}:{password}@{host}/'.format(
                user=self.__opts['user'],
                password=environ[self.__opts['password_env']],
                host=host)
        else:
            self.__url = 'https://{host}/'.format(host=host)
        self.logger.debug('Selected clickhouse host: %s', host)

    def push(self, records):
        if not records:
            return

        tskv_gen = (rec.tskv for rec in records)
        push_data = ''.join(tskv_gen).encode('utf-8')

        while True:  # Cross host retries
            try:
                r = requests.post(self.__url, params={'query': self.__query}, data=push_data, timeout=self.__timeout)
                if r.status_code == requests.codes.ok:
                    break
                else:
                    self.logger.error(r.text)
            except requests.exceptions.RequestException as exc:
                self.logger.exception(exc)
                self.__choose_host()

        self.logger.debug('Data pushed to clickhouse')
