# encoding: utf-8
import json

import requests
from requests.exceptions import ConnectionError, Timeout, RequestException, HTTPError
import os
import logging


log = logging.getLogger(__name__)


class TicketGetter(object):

    def get_service_ticket_headers(self, destinations, scopes=None):
        destinations = self._fix_list(destinations)
        str_dest = ','.join((str(x) for x in destinations))
        response = self._request_service_tickets(dest_tvm_id=str_dest)
        headers_by_destinations = {}
        for element in response:
            dst_id = response[element]['tvm_id']
            headers = {'X-Ya-Service-Ticket': response[element]['ticket']}
            headers_by_destinations[str(dst_id)] = headers

        return headers_by_destinations

    @staticmethod
    def _fix_list(value):
        """ Если нужен именно list """
        if isinstance(value, list):
            return value
        elif isinstance(value, (set, tuple)):
            return list(value)
        else:
            return [value]

    @staticmethod
    def _request_service_tickets(dest_tvm_id):
        """ Бегаем за тикетом в ручку TVM """
        tvm_origin = os.environ['QLOUD_TVM_INTERFACE_ORIGIN']
        url = '{host}tvm/tickets?dsts={tvm_dest}'.format(host=tvm_origin, tvm_dest=dest_tvm_id)
        try:
            response = requests.get(
                url,
                headers={
                    'Authorization': os.environ['QLOUD_TVM_TOKEN']
                },
                verify='/etc/ssl/certs/ca-certificates.crt'
            )
            response.raise_for_status()
            return response.json()
        except ConnectionError:
            raise TVMNetworkError
        except Timeout:
            raise TVMResponseError
        except HTTPError:
            raise TVMResponseError
        except RequestException:
            raise TVMResponseError


class TvmException(Exception):
    pass


class ContextException(TvmException):
    pass


class TicketException(TvmException):
    pass


class TicketParsingException(TvmException):
    def __init__(self, message, status, debug_info):
        self.message = message
        self.status = status
        self.debug_info = debug_info


class TVMNetworkError(TvmException):
    pass


class TVMResponseError(TvmException):
    pass
