import BaseHTTPServer
import json
import logging
import socket
import time
from SimpleHTTPServer import SimpleHTTPRequestHandler

import redis


class UnistatHandler(SimpleHTTPRequestHandler):
    _redis = redis.Redis()

    def do_GET(self):
        self.send_response(200)
        self.send_header("Content-type", "application/json")
        self.end_headers()
        start = time.time()
        stats = []
        keys = UnistatHandler._redis.keys(pattern='*')
        logging.info('{} keys in redis'.format(len(keys)))
        values = UnistatHandler._redis.mget(keys)
        for k, v in zip(keys, values):
            try:
                stats.append([k, int(v)])
            except ValueError:
                logging.warn('Redis key-value {}={} is not int, skipping'.format(k, v))
        result = json.dumps(stats)
        logging.debug('unistat: {}'.format(result))
        logging.info('getting stats finished in {}s'.format(time.time() - start))
        self.wfile.write(result)


class HTTPServerV6(BaseHTTPServer.HTTPServer):
    address_family = socket.AF_INET6


class UnistatServer:
    def __init__(self, port):
        logging.info('Server initialized with port {}'.format(port))
        self.httpd = HTTPServerV6(('::', port), UnistatHandler)

    def start(self):
        logging.info('Server started')
        self.httpd.serve_forever()


def main():
    logging.basicConfig(level=logging.DEBUG)
    server = UnistatServer(8000)
    server.start()


if __name__ == '__main__':
    main()
