import logging
from collections import defaultdict

import redis as redis


class Unistat:
    _redis = redis.Redis()
    _counter = defaultdict(int)

    @staticmethod
    def increment(counter_name, value):
        try:
            Unistat._redis.incr(counter_name, value)
        except Exception, err:
            logging.error("Can't increment counter '%s' by %s, cause: %s", counter_name, value, err.message)
        Unistat._counter[counter_name] += 1
