from logbroker_processors.windat.winmaildat.mulca import MulcaClient
from ..processors import Processor
from winmaildat.winmaildat import process_windat, WindatId
from winmaildat.tnef import get_tnef_parser
from winmaildat.windat_logger import get_logger

log = get_logger(__name__)


class WindatMessageProcesor(Processor):
    REQ_ARGS = [
        'uid', 'mid', 'hid', 'fileType', 'name'
    ]

    def __init__(self, tnef_parser_lib=None, *args, **kwargs):
        super(WindatMessageProcesor, self).__init__()
        self._tnef_parser = get_tnef_parser(
            tnef_lib=tnef_parser_lib  # None is default, which means libtnef for now.
        )
        self._mulca_client = MulcaClient(**kwargs.pop('mulca'))
        log.debug('Gotta config %s' % kwargs)
        self.config = kwargs

    def is_windat(self, fileType, name):
        return 'ms-tnef' in fileType.lower() or name.lower() == 'winmail.dat'

    def process(self, header, data):
        if all([req_args in data.keys() for req_args in self.REQ_ARGS]) and self.is_windat(data['fileType'], data['name']):
            uid, mid, hid, config = data['uid'], data['mid'], data['hid'], self.config
            log.set_current_win_dat(WindatId(uid, mid, hid))
            log.debug('started processing windat')
            try:
                process_windat(
                    uid, mid,
                    hid, config,
                    mulca_client=self._mulca_client,
                    tnef_parser=self._tnef_parser
                )
            except Exception as e:
                log.exception('failed to process windat')
        return True
