"""
Returns a libtnef-compatible module instance.
"""
from importlib import import_module


DEFAULT_TNEF_LIB = 'libtnef'


def get_tnef_parser(tnef_lib=None):
    """
    If parser lib is not set, assume default.
    Otherwise, return `tnef_lib` as-is.

    For tests to work, it must be something like an
    instance of MagicMock.
    """
    if tnef_lib is None:
        return import_module(DEFAULT_TNEF_LIB)
    return tnef_lib
