# coding: utf-8

import logging
from threading import local


class WinDatAdapter(logging.LoggerAdapter):
    local = local()

    def __init__(self, logger, extra):
        super(WinDatAdapter, self).__init__(logger, extra)
        WinDatAdapter.local.win_dat = (None, None, None)

    @classmethod
    def set_current_win_dat(cls, win_dat):
        cls.local.win_dat = win_dat

    def _get_wd(self):
        return getattr(self.local.wind_data, 'win_dat', None)

    def process(self, msg, kwargs):
        return repr(self.local.win_dat) + ' ' + msg, kwargs


def get_logger(name):
    logger = logging.getLogger(name)
    return WinDatAdapter(logger, None)
