# -*- encoding: utf-8 -*-
import os
from setuptools import setup, Extension
from setuptools.command.build_ext import build_ext
from setuptools.dist import Distribution


class lazy_cythonize(list):
    def __init__(self, callback):
        self._list, self.callback = None, callback

    def c_list(self):
        if self._list is None:
            self._list = self.callback()
        return self._list

    def __iter__(self):
        for e in self.c_list():
            yield e

    def __getitem__(self, ii):
        return self.c_list()[ii]

    def __len__(self):
        return len(self.c_list())


def ext_modules():
    from Cython.Build import cythonize

    v2_includes = ['src/utvm/v2']
    if os.path.exists(os.path.abspath('/usr/include/ticket_parser2')):
        v2_includes.append(os.path.abspath('/usr/include/ticket_parser2'))
    else:
        v2_includes.append(os.path.abspath('src/utvm/v2/fallback_headers'))

    return cythonize([
        Extension(
            'utvm.v2.tvm2',
            sources=['src/utvm/v2/tvm2.pyx'],
            libraries=['ticket_parser2'],
            include_dirs=v2_includes,
            library_dirs=['/usr/lib'],
            runtime_library_dirs=['/usr/lib'],
        ),
    ])


class BinaryDistribution(Distribution):
    def is_pure(self):
        return False


setup(
    name='utvm',
    version='1.0.3',
    author='Andrey Mitrofanov',
    author_email='drew@yandex-team.ru',
    description='Universal TVM library',
    package_dir={'': 'src'},
    packages=['utvm', 'utvm.common', 'utvm.v2'],
    include_package_data=True,
    distclass=BinaryDistribution,
    setup_requires=['Cython'],
    install_requires=['requests', 'six', 'enum34'],
    ext_modules=lazy_cythonize(ext_modules),
    cmdclass={'build_ext': build_ext},
    zip_safe=True,
)
