from libc.stdint cimport uint32_t, uint64_t
from libc.time cimport time_t
from cython.operator cimport dereference


cdef extern from "ticket_parser2_inc.h":
    cdef enum TA_EErrorCode:
        TA_EC_OK = 0,
        TA_EC_DEPRECATED,
        TA_EC_EMPTY_TVM_KEYS,
        TA_EC_EXPIRED_TICKET,
        TA_EC_INVALID_BLACKBOX_ENV,
        TA_EC_INVALID_DST,
        TA_EC_INVALID_PARAM,
        TA_EC_INVALID_TICKET_TYPE,
        TA_EC_MALFORMED_TICKET,
        TA_EC_MALFORMED_TVM_KEYS,
        TA_EC_MALFORMED_TVM_SECRET,
        TA_EC_MISSING_KEY,
        TA_EC_NOT_ALLOWED,
        TA_EC_SIGN_BROKEN,
        TA_EC_SMALL_BUFFER,
        TA_EC_UNEXPECTED_ERROR,
        TA_EC_UNSUPPORTED_VERSION,
    cdef struct TA_TServiceContext
    cdef struct TA_TCheckedServiceTicket
    cdef struct TA_TUserContext
    cdef struct TA_TCheckedUserTicket


cdef extern from "ticket_parser2_inc.h":
    cdef enum TA_EBlackboxEnv:
        TA_BE_PROD = 0,
        TA_BE_TEST,
        TA_BE_PROD_YATEAM,
        TA_BE_TEST_YATEAM,
        TA_BE_STRESS


cdef extern from "ticket_parser2_inc.h":
    cdef const char* TA_ErrorCodeToString(TA_EErrorCode code)


cdef extern from "ticket_parser2_inc.h":
    cdef TA_EErrorCode TA_CreateServiceContext(
        uint32_t clientId,
        const char* secretBase64,
        size_t secretBase64Size,
        const char* tvmKeysResponse,
        size_t tvmKeysResponseSize,
        TA_TServiceContext** context)

    cdef TA_EErrorCode TA_DeleteServiceContext(TA_TServiceContext* context)

    cdef TA_EErrorCode TA_CheckServiceTicket(
        const TA_TServiceContext* context,
        const char* ticketBody,
        size_t ticketBodySize,
        TA_TCheckedServiceTicket** ticket)

    cdef TA_EErrorCode TA_DeleteServiceTicket(TA_TCheckedServiceTicket* ticket)

    cdef TA_EErrorCode TA_GetServiceTicketSrc(
        const TA_TCheckedServiceTicket* ticket,
        uint32_t* srcClientId)

    cdef TA_EErrorCode TA_GetServiceTicketDebugInfo(
        const TA_TCheckedServiceTicket* ticket,
        char* debugInfo,
        size_t* debugInfoSize,
        size_t maxDebugInfoSize)

    cdef TA_EErrorCode TA_RemoveServiceTicketSignature(
        const char* ticketBody,
        size_t ticketBodySize,
        const char** logableTicket,
        size_t* logableTicketSize)

    cdef TA_EErrorCode TA_SignCgiParamsForTvm(
        const TA_TServiceContext* context,
        const char* ts,
        size_t tsSize,
        const char* dst,
        size_t dstSize,
        const char* scopes,
        size_t scopesSize,
        char* signature,
        size_t* signatureSize,
        size_t maxSignatureSize)


cdef extern from "ticket_parser2_inc.h":
    cdef TA_EErrorCode TA_CreateUserContext(
        TA_EBlackboxEnv env,
        const char* tvmKeysResponse,
        size_t tvmKeysResponseSize,
        TA_TUserContext** context)

    cdef TA_EErrorCode TA_DeleteUserContext(TA_TUserContext* context)

    cdef TA_EErrorCode TA_CheckUserTicket(
        const TA_TUserContext* context,
        const char* ticketBody,
        size_t ticketBodySize,
        TA_TCheckedUserTicket** ticket)

    cdef TA_EErrorCode TA_DeleteUserTicket(TA_TCheckedUserTicket* context)

    cdef TA_EErrorCode TA_GetUserTicketUidsCount(
        const TA_TCheckedUserTicket* ticket,
        size_t* count)

    cdef TA_EErrorCode TA_GetUserTicketUid(
        const TA_TCheckedUserTicket* ticket,
        size_t idx,
        uint64_t* uid)

    cdef TA_EErrorCode TA_GetUserTicketDefaultUid(
        const TA_TCheckedUserTicket* ticket,
        uint64_t* uid)

    cdef TA_EErrorCode TA_GetUserTicketScopesCount(
        const TA_TCheckedUserTicket* ticket,
        size_t* count)

    cdef TA_EErrorCode TA_GetUserTicketScope(
        const TA_TCheckedUserTicket* ticket,
        size_t idx,
        const char** scope)

    cdef TA_EErrorCode TA_HasUserTicketScope(
        const TA_TCheckedUserTicket* ticket,
        const char* scope,
        size_t scopeSize,
        int* checkingResult)

    cdef TA_EErrorCode TA_GetUserTicketDebugInfo(
        const TA_TCheckedUserTicket* ticket,
        char* debugInfo,
        size_t* debugInfoSize,
        size_t maxDebugInfoSize)

    cdef TA_EErrorCode TA_RemoveUserTicketSignature(
        const char* ticketBody,
        size_t ticketBodySize,
        const char** logableTicket,
        size_t* logableTicketSize)

cdef extern from "ticket_parser2_inc.h":
    cdef const char* TA_LibVersion()
