/*
 How to run this in docker:
arcadia/mail/hound/doc/api/v2$ docker pull node:8-slim
arcadia/mail/hound/doc/api/v2$ docker run -it --rm --name build-readme -v "$PWD":/usr/src/app -w /usr/src/app node:8-slim npm install raml2html && nodejs make_doc.js > README.md

 */
const raml2html = require('raml2html');
const nunjucks = require('nunjucks');
let config = raml2html.getConfigForTemplate('index.nunjucks');


config.processRamlObj = function(ramlObj, config) {
    const env = nunjucks.configure(__dirname, { autoescape: false });
    ramlObj.isStandardType = function(type) {
      if (typeof type === 'object') {
        return false;
      }
      return type && type.indexOf('{') === -1 && type.indexOf('<') === -1;
    };

    return new Promise((resolve) => {
      const result = env.render('index.nunjucks', ramlObj);
      if (config.processOutput) {
        resolve(config.processOutput(result));
      }

      return resolve(result);
    });
  }

config.postProcessHtml = function(data) {
    data = data.replace(/\\\n/g, '');
    data = data.replace(/ {1,}\n/g, '');
    data = data.replace(/&quot;/g, '"');
    return data.replace(/\n{3,}/g, '\n\n');
  }


// source can either be a filename, url, or parsed RAML object
raml2html.render('api.raml', config).then(function(result) {
    process.stdout.write(result);
}, function(error) {
    if (error.message) {
        console.error(error.message);
    }
    if (error.parserErrors) {
        console.error(JSON.stringify(error.parserErrors, null, 2));
    }
    process.exit(1);
});
