#pragma once

#include <unordered_map>

#include <yplatform/ptree.h>

#include <mail/hound/include/internal/logger.h>
#include <macs_pg/macs_pg.h>
#include <mail_getter/service_factory.h>
#include <pa/async.h>
#include <mail/tvm_guard/ymod_tvm/ymod_tvm.h>
#include <mail/http_getter/client/include/module.h>
#include <mail/ymod_maildb/include/module.h>

namespace hound {

struct RecognizerConfig {
    std::string languageDict;
    std::string languageWeights;
    std::string encodingDict;
};

class Config {
public:
    Config(const yplatform::ptree& cfg, http_getter::TypedModulePtr http);

    Config(const Config &) = delete;

    Config& operator=(const Config &) = delete;

    using ServiceName = std::string;
    using PgDbUser = std::string;
    using ServicesDbUsers = std::unordered_map<ServiceName, PgDbUser>;

    mail_getter::ServiceFactoryPtr mailStorage() const {
        return mailStorage_;
    }

    int itemsPerPage() const {
        return itemsPerPage_;
    }

    const ServicesDbUsers& servicesDbUsers() const {
        return servicesDbUsers_;
    }

    std::size_t countersLimit() const {
        return countersLimit_;
    }

    std::size_t mailboxLimit() const {
        return mailboxLimit_;
    }

    std::size_t tidsLimit() const {
        return tidsLimit_;
    }

    std::size_t coroutineStackSize() const {
        return coroutineStackSize_;
    }

    const RecognizerConfig& recognizer() const {
        return recognizer_;
    }

    const mail_getter::attach_sid::Keys& keys() const {
        return keys_;
    }

    const http_getter::TypedEndpoint& passportEndpoint() const {
        return passportEndpoint_;
    }

    const http_getter::TypedModulePtr& httpClient() const {
        return http_;
    }

    ymod_maildb::ModulePtr mailDb() const {
        return maildb_;
    }

private:
    mail_getter::ServiceFactoryPtr mailStorage_;
    unsigned int itemsPerPage_;
    std::unordered_map<ServiceName, PgDbUser> servicesDbUsers_;
    std::size_t countersLimit_;
    std::size_t mailboxLimit_;
    std::size_t tidsLimit_;
    std::size_t coroutineStackSize_;
    RecognizerConfig recognizer_;
    mail_getter::attach_sid::Keys keys_;
    http_getter::TypedEndpoint passportEndpoint_;
    http_getter::TypedModulePtr http_;
    ymod_maildb::ModulePtr maildb_;
};

using ConfigPtr = std::shared_ptr<Config>;

ConfigPtr makeConfig(const yplatform::ptree& cfg, http_getter::TypedModulePtr http);

}
