#pragma once

#include <memory>
#include <yplatform/log.h>
#include <logdog/logger.h>
#include <logdog/format/tskv.h>
#include <logdog/format/json.h>
#include <logdog/backend/yplatform_log.h>
#include <logdog/attributes/mail_attributes.h>
#include <macs/types.h>

namespace hound {
namespace log {

LOGDOG_DEFINE_ATTRIBUTE(int, code)
LOGDOG_DEFINE_ATTRIBUTE(int, wmi_code)
LOGDOG_DEFINE_ATTRIBUTE(macs::Fid, fid)
LOGDOG_DEFINE_ATTRIBUTE(macs::Lid, lid)
LOGDOG_DEFINE_ATTRIBUTE(std::vector<macs::Mid>, mids)
LOGDOG_DEFINE_ATTRIBUTE(boost::optional<std::string>, caller)

using namespace ::logdog::attr;

constexpr static auto hound_formatter = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-hound-tskv-log"));

} // namespace log

inline auto getModuleLogger() {
    auto logger = std::make_shared<yplatform::log::source>(YGLOBAL_LOG_SERVICE, "hound");
    return ::logdog::make_log(log::hound_formatter, logger);
}

using ModuleLogger = decltype(getModuleLogger());

inline auto getContextLogger(const std::string& requestId, boost::optional<std::string> uid) {
    auto uid_param = uid ? log::uid=uid.get() : log::uid=::logdog::none;
    return ::logdog::bind(getModuleLogger(), uid_param, log::request_id=requestId);
}

using ContextLogger = decltype(getContextLogger("", boost::none));

inline auto getStateHistoryLogger() {
    auto logger = ::logdog::make_log(
            ::logdog::json::formatter,
            std::make_shared<yplatform::log::source>(YGLOBAL_LOG_SERVICE, "state_history"),
            ::logdog::filters::make_sequence<::logdog::filters::expand_system_error>{}
    );
    return logger;
}

using StateHistoryLogger = decltype(getStateHistoryLogger());

} // namespace hound
