#pragma once

#include <yplatform/module.h>
#include <yplatform/reactor.h>

#include <mail/hound/include/internal/logger.h>
#include <mail/hound/include/internal/config.h>

#include <yamail/data/serialization/ptree.h>

BOOST_FUSION_ADAPT_STRUCT(pgg::statistic::ConnectionStats,
    freeConnections,
    busyConnections,
    pendingConnections,
    maxConnections,
    queueSize,
    droppedTimedOut,
    droppedFailed,
    droppedBusy,
    droppedWithResult
)

namespace hound {

struct Module: public yplatform::module {
    Module() = default;

    void init(const yplatform::ptree& cfg);

private:
    void initPa(const yplatform::ptree& cfg);
    void bindHandlers(const std::string& serverName, const std::string& tvmGuardName);
    ConfigPtr config;
    std::shared_ptr<yplatform::reactor> reactor;
};

} // namespace hound
