#pragma once

#include <yamail/data/serialization/json_writer.h>
#include <mail_errors/error_code.h>

namespace hound::reflection {

struct Error {
    Error(const mail_errors::error_code& e)
            : code(e.value())
            , message(e.message())
            , reason(e.category().message(e.value()))
    { }

    int code = 0;
    std::string message;
    std::string reason;
};

}

BOOST_FUSION_ADAPT_STRUCT(hound::reflection::Error,
        (int, code)
        (std::string, message)
        (std::string, reason) )
