#pragma once

#include <ymod_webserver/response.h>
#include <ymod_webserver/codes.h>

#include <mail/hound/include/internal/config.h>
#include <mail/hound/include/internal/server/context.h>
#include <mail/hound/include/internal/wmi/yplatform/reflection/error.h>

#include <boost/asio/spawn.hpp>

namespace hound::server {

struct Base {
    ConfigPtr config_;

    Base(ConfigPtr configuration)
        : config_(configuration)
    { }

    virtual ~Base() { }

    void process(const ymod_webserver::http::stream_ptr& stream, boost::asio::yield_context yield);

    virtual bool isAccepted(ymod_webserver::methods::http_method method) const {
        return ymod_webserver::methods::mth_get == method || ymod_webserver::methods::mth_post == method;
    }

    virtual void execute(ContextPtr, boost::asio::yield_context) const = 0;

protected:
    using Request = hound::server::Context;
    using RequestPtr = std::shared_ptr<Request>;
    using Logger = ContextLogger;
    using YieldContext = decltype(macs::io::make_yield_context(std::declval<boost::asio::yield_context>()));

    Config& config() const {
        return *config_;
    }
};

}
