#pragma once

#include <mail_getter/AttachShieldCrypto.h>
#include <mail/hound/include/internal/wmi/yplatform/reflection/attach_sid_structs.h>
#include <mail/hound/include/internal/server/base.h>
#include <yamail/data/deserialization/json_reader.h>

namespace hound::server::handlers {

class AttachSid : public Base {
public:
    explicit AttachSid(ConfigPtr config)
        : Base(config) {
    }
    bool isAccepted(ymod_webserver::methods::http_method method) const override {
        return ymod_webserver::methods::mth_post == method;
    }

private:
    using SinglePart = mail_getter::part_id::SingleMessagePart;
    using MultiplePart = mail_getter::part_id::MultipleMessagePart;

    void execute(RequestPtr r, boost::asio::yield_context /*yield*/) const override {
        Request & request = *r;

        const std::chrono::hours timeout(3 * 24);
        const mail_getter::attach_sid::Packer attachShield(timeout, config().keys());
        try {
            AttachSidsResponse resp;

            const auto rawBody = request.getRawBody();
            const auto data = yamail::data::deserialization::fromJson<AttachSidsRequest>(rawBody);
            if (!data.empty() && (data.size() > 1 || data.front().downloads.size() > 1)) {
                LOGDOG_(request.logger, warning, log::message="more than 1 uid/mid per request: " + rawBody, log::where_name=request.method);
            }

            std::transform(data.begin(), data.end(), std::back_inserter(resp), [&](const auto& uidDownloads) {
                const std::string uid = uidDownloads.uid;
                std::vector<std::string> sids;

                const auto unaryOp = [&] (const auto& midHids) {
                    if (midHids.hids.size() == 1) {
                        const SinglePart part{uid, midHids.mid, midHids.hids.front()};
                        const std::string packedData = attachShield(part);
                        return encode_url(packedData);
                    } else {
                        const MultiplePart part{uid, midHids.mid, midHids.hids};
                        const std::string packedData = attachShield(part);
                        return encode_url(packedData);
                    }
                };

                std::transform(uidDownloads.downloads.begin(), uidDownloads.downloads.end(),
                        std::back_inserter(sids), unaryOp);
                return UidSids{uid, sids};
            });


            request.response(resp, "result");
        } catch (const std::exception& e) {
            request.responseError(libwmi::error::internal, e.what());
        }
    }
};

}
