#pragma once

#include <mail/hound/include/internal/server/handlers/macs.h>
#include <mail/hound/include/internal/wmi/yplatform/reflection/counters.h>
#include <macs/envelopes_repository.h>
#include <macs/folders_repository.h>
#include <boost/range/adaptors.hpp>
#include <boost/range/algorithm/for_each.hpp>

namespace hound::server::handlers {

class CountersHandler : public MacsHandler {
public:
    CountersHandler(ConfigPtr config)
        : MacsHandler(config) {
    }

protected:
    typedef macs::FolderSet Folders;
    void executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const override {
        auto yield = macs::io::make_yield_context(yieldCtx);
        Counters counters;
        counters.fresh = metadata->envelopes().getFreshCounter(yield);
        counters.unread = getUnread(metadata->folders().getAllFolders(yield));
        request->response(counters, "counters");
    }
private:
    size_t getUnread(const Folders& folders) const {
        size_t res = 0;
        boost::for_each(folders | boost::adaptors::filtered(inboxOrUser), boost::bind(sumUnread, _1, boost::ref(res)));
        return res;
    }
    static bool inboxOrUser(const Folders::value_type& l) {
        const macs::Folder::Symbol sy = l.second.symbolicName();
        return sy == macs::Folder::Symbol::inbox || sy == macs::Folder::Symbol::none;
    }
    static void sumUnread(const Folders::value_type& l, size_t& res) {
        res += l.second.newMessagesCount();
    }
};

}
