#pragma once

#include <mail/hound/include/internal/server/handlers/messages.h>
#include <mail/hound/include/internal/wmi/yplatform/reflection/envelopes.h>
#include <boost/range/adaptor/transformed.hpp>

BOOST_FUSION_ADAPT_STRUCT(macs::MidStid,
        (std::string, mid)
        (std::string, stid) )

namespace hound::server::handlers {

class DeletedMessagesHandler : public MessagesHandler {
public:
    DeletedMessagesHandler(ConfigPtr config)
        : MessagesHandler(config, UserStrategy::existingThenDeleted) {
    }

protected:
    struct QueryParams :
            public Params::Page,
            public Params::TimestampRange,
            public Params::MessageFormat {
    };

    void executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yield) const override {
        QueryParams params;
        if (!getQueryParams(params, *request, *metadata, yield))
            return;

        macs::EnvelopesQueryDeleted query = metadata->envelopes().query()
                .deleted()
                .from(params.first)
                .count(params.count);

        if (params.timestampRange) {
            query.withinInterval(*params.timestampRange);
        }

        const std::vector<helpers::Envelope> envelopes = get(std::move(query), yield);

        switch (params.messageFormat) {
            case Params::MessageFormat::Format::full: {
                request->response(envelopes, "envelopes");
                break;
            }

            case Params::MessageFormat::Format::midStid:
            case Params::MessageFormat::Format::none: {
                auto midStids = envelopes | boost::adaptors::transformed([](auto& e) {
                    return macs::MidStid(e.mid(), e.stid());
                });
                macs::MidsWithStids messages = {std::begin(midStids), std::end(midStids)};

                request->response(messages, "deleted_messages");
                break;
            }
        }
    }
};

}
