#pragma once

#include <mail/hound/include/internal/server/handlers/macs.h>
#include <macs/envelopes_repository.h>

namespace hound::server::handlers {

class FilterSearchHandler : public MacsHandler {
public:
    FilterSearchHandler(ConfigPtr config)
        : MacsHandler(config) {
    }

protected:
    void execute(RequestPtr r, boost::asio::yield_context yield) const final {
        Request & request = *r;
        try {
            MailMetadataPtr metadata(getMetadata(request));
            executeMacs(r, metadata, yield);
        } catch (const std::exception& e) {
            LOGDOG_(request.logger, error, log::where_name=request.method, log::exception=e);
            setErrorHeader(request);
            throw;
        }
    }
    void executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const override;

    ::macs::pg::QueryHandleStrategy defaultQueryStrategy() const override {
        return ::macs::pg::readReplicaThenMaster;
    }

private:
    struct FilterSearchParams {
        std::list<std::string> fids;
        std::list<std::string> lids;
        std::list<std::string> mids;
        bool onlyUnread;
        bool onlyAttachments;
        macs::EnvelopesSorting order;
        std::string folderSet;
        bool isFullFoldersAndLabels;
        bool needMailboxRevision;
    };

    struct FoldersFilter {
        std::list<macs::Folder::Symbol> includeFolders;
        std::list<macs::Folder::Symbol> excludeFolders;
        bool onlyUseful;
    };

    bool getFolderSymbolsParam(Request& request, const std::string& paramName,
            std::list<macs::Folder::Symbol> &symbols) const;
    bool getFoldersFilter(Request& request, FoldersFilter &filter) const;
    bool checkFoldersFilter(Request& request, FoldersFilter &filter) const;
    void filterFids(FoldersFilter &filter, macs::Service& metadata,
            std::list<macs::Fid> &fids, boost::asio::yield_context yield) const;
    bool getFids(Request& request, macs::Service& metadata, std::list<macs::Fid> &fids, boost::asio::yield_context yield) const;
    bool getMids(Request& request, std::list<macs::Mid> &mids) const;
    bool getLids(Request& request, std::list<macs::Lid> &lids) const;
    bool getFilterSearchParams(Request& request, macs::Service& metadata,
            FilterSearchParams &params, boost::asio::yield_context yield) const;
    static bool getLogicalParam(Request& request, const std::string& paramName);

    template <typename T>
    void response(Request & request, boost::optional<macs::Revision> mailboxRevision, T&& envelopes) const;
    void setErrorHeader(Request& request) const;
};

}
