#pragma once

#include <mail/hound/include/internal/server/handlers/macs.h>

namespace hound::server::handlers {

class FirstEnvelopeDate : public MacsHandler {
public:
    FirstEnvelopeDate(ConfigPtr config)
        : MacsHandler(config) {
    }

protected:
    void executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const override {
        auto yield = macs::io::make_yield_context(yieldCtx);
        const auto fid = request->getArg("fid");

        if (fid.empty()) {
            request->responseError(libwmi::error::invalidArgument, "fid is missing or empty");
            return;
        }

        macs::error_code ec;
        const auto date = metadata->envelopes().getFirstEnvelopeDate(fid, yield[ec]);
        if (ec) {
            request->responseError(libwmi::error::dbUnknownError, ec.message());
        } else {
            request->response(date, "first_envelope_date");
        }
    }
};

}
