#pragma once

#include <mail/hound/include/internal/server/handlers/messages.h>
#include <mail/hound/include/internal/wmi/yplatform/reflection/envelopes.h>

namespace hound::server::handlers {

class FolderTabsNewCountersHandler : public MacsHandler {
public:
    FolderTabsNewCountersHandler(ConfigPtr config)
        : MacsHandler(config) {
    }

protected:
    void executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const override {
        auto yield = macs::io::make_yield_context(yieldCtx);
        std::size_t limit = 0;
        if (!boost::conversion::try_lexical_convert(request->getArg("limit"), limit)) {
            limit = config().countersLimit();
        }

        macs::TabSet tabs = metadata->tabs().canReadTabs(yield) ?
                    metadata->tabs().getAllTabs(yield) :
                    macs::TabSet{};

        const auto c = tabs | boost::adaptors::transformed([limit](auto &t) {
            return std::make_pair(t.first.toString(),
                                  std::min(t.second.newMessagesCount(), limit));
        });
        request->response(std::map<std::string, std::size_t>{c.begin(), c.end()}, "new_counters");
    }
};

}
