#pragma once

#include <mail/hound/include/internal/server/handlers/macs.h>
#include <mail/hound/include/internal/wmi/yplatform/helpers/detailed_envelopes.h>
#include <mail/hound/include/internal/wmi/yplatform/reflection/folders.h>

namespace hound::server::handlers {

class FoldersHandler : public MacsHandler {
public:
    FoldersHandler(ConfigPtr config)
        : MacsHandler(config) {
    }

protected:
    void executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const override {
        bool withHidden = request->getOptionalArg("with_hidden").is_initialized();
        macs::FolderSet folders = getAllFolders(metadata, withHidden, yieldCtx);
        using namespace boost::adaptors;
        auto out = folders | map_values | transformed([&](const auto &folder) {
            return std::make_pair(folder.fid(), helpers::FolderWithPath{folder, folders.getPath(folder)});
        });
        request->response(std::map<macs::Fid, helpers::FolderWithPath>{out.begin(), out.end()}, "folders");
    }

    macs::FolderSet getAllFolders(MailMetadataPtr metadata, bool withHidden, boost::asio::yield_context yieldCtx) const {
        auto yield = macs::io::make_yield_context(yieldCtx);
        if (withHidden) {
            return metadata->folders().getAllFoldersWithHidden(yield);
        } else {
            return metadata->folders().getAllFolders(yield);
        }
    }

};

}
