#pragma once

#include <mail/hound/include/internal/server/handlers/macs.h>
#include <mail/hound/include/internal/wmi/yplatform/reflection/folders_counters.h>

#include <boost/range/adaptors.hpp>

namespace hound::server::handlers {

class FoldersCountersHandler : public MacsHandler {
public:
    FoldersCountersHandler(ConfigPtr config)
        : MacsHandler(config) {
    }

protected:
    void executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const override {
        auto yield = macs::io::make_yield_context(yieldCtx);
        macs::FolderSet folders = metadata->folders().getAllFolders(yield);
        request->response(getCounters(folders), "folders");
    }

private:
    static std::map<std::string, FoldersCounters> getCounters(const macs::FolderSet& folders) {
        using boost::range::transform;
        std::map<std::string, FoldersCounters> foldersCounters;
        transform(folders, std::inserter(foldersCounters, foldersCounters.end()), [](const macs::FolderSet::value_type& p) {
            return std::make_pair(p.first, FoldersCounters(p.second));
        });

        return foldersCounters;
    }
};

}
