#pragma once

#include <mail/hound/include/internal/server/handlers/macs.h>
#include <macs/folder.h>


namespace hound::server::handlers {

class ImapUnsubscribedFolders : public MacsHandler {
public:
    ImapUnsubscribedFolders(ConfigPtr config)
        : MacsHandler(config) {
    }

protected:
    void executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const override {
        auto yield = macs::io::make_yield_context(yieldCtx);
        mail_errors::error_code ec;
        const auto response = metadata->imapRepo().imapGetUnsubscribed(yield[ec]);

        if (ec) {
            request->responseError(libwmi::error::dbUnknownError, ec.message());
        } else {
            std::vector<std::string> folders;

            std::transform(response.begin(), response.end(), std::back_inserter(folders), [](const macs::ImapUnsubscribedData &data) {
                return boost::algorithm::join(data.fullName, macs::pathSeparator);
            });

            request->response(folders, "imap_unsubscribed_folders");
        }
    }
};

}
