#pragma once

#include <mail/hound/include/internal/server/handlers/macs.h>
#include <mail/hound/include/internal/wmi/yplatform/reflection/envelopes.h>
#include <macs/envelopes_repository.h>

namespace hound::server::handlers {

class InReplyToHandler : public MacsHandler {
public:
    InReplyToHandler(ConfigPtr config)
        : MacsHandler(config) { }

protected:
    void executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const override {
        auto yield = macs::io::make_yield_context(yieldCtx);
        const std::string msgId = request->getArg("message_id");
        if (msgId.empty()) {
            request->responseError(libwmi::error::invalidArgument,
                                   "message_id parameter is required");
            return;
        }

        const auto result = metadata->envelopes().query()
                .inReplyTo()
                .msgId(msgId)
                .get(yield);

        const std::vector<helpers::Envelope> envelopes{std::begin(result), std::end(result)};
        request->response(envelopes, "envelopes");
    }

    ::macs::pg::QueryHandleStrategy defaultQueryStrategy() const override {
        return ::macs::pg::readReplicaThenMaster;
    }
};

}
