#pragma once

#include <mail/hound/include/internal/server/handlers/macs.h>
#include <mail/hound/include/internal/wmi/yplatform/reflection/labels.h>
#include <macs/labels_repository.h>

namespace hound::server::handlers {

class LabelsHandler : public MacsHandler {
public:
    LabelsHandler(ConfigPtr config)
        : MacsHandler(config) {
    }

protected:
    void executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const override {
        auto yield = macs::io::make_yield_context(yieldCtx);
        macs::LabelSet labels = metadata->labels().getAllLabels(yield);
        request->response(labels, "labels");
    }
};

}
