#pragma once

#include <mail/hound/include/internal/server/handlers/macs.h>

namespace hound::server::handlers {

class MailboxRevision : public MacsHandler {
public:
    MailboxRevision(ConfigPtr config)
        : MacsHandler(config) {
    }

protected:
    void executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const override {
        auto yield = macs::io::make_yield_context(yieldCtx);
        const unsigned long revision = metadata->folders().getMailboxRevision(yield);
        request->response(revision, "mailbox_revision");
    }
};

}
