#pragma once

#include <boost/type_traits.hpp>
#include <boost/utility.hpp>
#include <mail/hound/include/internal/server/handlers/macs.h>
#include <mail/hound/include/internal/server/query_params.h>
#include <mail/hound/include/internal/wmi/yplatform/helpers/envelopes.h>
#include <macs/envelopes_repository.h>

namespace hound::server::handlers {

class MessagesHandler : public MacsHandler {
public:
    MessagesHandler(ConfigPtr config, UserStrategy userStrategy = UserStrategy::existingOnly)
        : MacsHandler(std::move(config), userStrategy) {
    }

protected:
    struct Mailbox {
        Mailbox(const macs::Service& m, boost::asio::yield_context yield) : metadata(m), yield(yield) {}

        const macs::Service& metadata;
        boost::asio::yield_context yield;

        auto labels() const {
            return metadata.labels().getAllLabels(macs::io::make_yield_context(yield));
        }

        auto folders() const {
            return metadata.folders().getAllFoldersWithHidden(macs::io::make_yield_context(yield));
        }

        auto tabs() const {
            return metadata.tabs().getAllTabs(macs::io::make_yield_context(yield));
        }
    };

    using Params = server::QueryParams;
    Params queryParams;

    template<class QP>
    bool getQueryParams(QP& params, Request& request, macs::Service& metadata, boost::asio::yield_context yield) const {
        error_code ec = queryParams.getParams(params, request, Mailbox(metadata, yield));
        if (ec) {
            request.responseError(ec);
            return false;
        }
        return true;
    }

    template <typename Query>
    static std::vector<helpers::Envelope> get(Query&& query, boost::asio::yield_context yield) {
        const auto result = query.get(macs::io::make_yield_context(yield));
        const std::vector<helpers::Envelope> envelopes{std::begin(result), std::end(result)};
        return envelopes;
    }
};

}
