#pragma once

#include <mail/hound/include/internal/server/handlers/messages.h>
#include <mail/hound/include/internal/wmi/yplatform/reflection/envelopes.h>

namespace hound::server::handlers {

class MessagesByFolderHandler : public MessagesHandler {
public:
    MessagesByFolderHandler(ConfigPtr config)
        : MessagesHandler(config) {
    }

protected:
    struct QueryParams :
            public Params::Page,
            public Params::FolderOrInbox,
            public Params::TimestampRange,
            public Params::SortType  {
    };

    void executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yield) const override {
        QueryParams params;
        if (!getQueryParams(params, *request, *metadata, yield))
            return;

        macs::EnvelopesQueryInFolder query = metadata->envelopes().query()
            .inFolder(params.folder)
            .from(params.first)
            .count(params.count)
            .sortBy(params.sortType);

        if (params.timestampRange) {
            query.withinInterval(*params.timestampRange);
        }

        const std::vector<helpers::Envelope> envelopes = get(std::move(query), yield);

        request->response(envelopes, "envelopes");
    }
};

}
