#pragma once

#include <mail/hound/include/internal/server/handlers/messages.h>
#include <mail/hound/include/internal/wmi/yplatform/reflection/envelopes.h>

namespace hound::server::handlers {

class MessagesByLabelHandler : public MessagesHandler {
public:
    MessagesByLabelHandler(ConfigPtr config)
        : MessagesHandler(config) {
    }

protected:
    struct QueryParams :
            public Params::Page,
            public Params::Label,
            public Params::SortType  {
    };

    void executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yield) const override {
        QueryParams params;
        if (!getQueryParams(params, *request, *metadata, yield))
            return;

        const auto query = metadata->envelopes().query()
            .inMailbox()
            .from(params.first)
            .count(params.count)
            .withLabel(params.label)
            .sortBy(params.sortType);

        const std::vector<helpers::Envelope> envelopes = get(std::move(query), yield);

        request->response(envelopes, "envelopes");
    }
};

}
