#pragma once

#include <macs/types.h>
#include <mail/hound/include/internal/server/handlers/macs.h>

namespace hound::server::handlers {

class MessagesByMessageIdHandler : public MacsHandler {
public:
    MessagesByMessageIdHandler(ConfigPtr config)
        : MacsHandler(config) {
    }

protected:
    void executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const override {
        auto yield = macs::io::make_yield_context(yieldCtx);
        const std::string msgId = request->getArg("msgid");

        if (msgId.empty()) {
            request->responseError(libwmi::error::invalidArgument, "msgid parameter is required");
            return;
        }

        macs::Fid fid;
        if (request->getArgument("fid", fid)) {
            macs::error_code ec;
            macs::MidAndImapIdVec response = metadata->envelopes().getByMessageId(fid, msgId, yield[ec]);

            if (ec) {
                request->responseError(libwmi::error::internal, ec.message());
            } else if (response.size() != 1) {
                request->responseError(libwmi::error::internal,
                                       "expected exactly one mid, but query returned " + std::to_string(response.size()));
            } else {
                macs::MidList mids(response.size());
                std::transform(response.begin(), response.end(), mids.begin(),
                               [](const macs::MidAndImapId &e) { return e.mid; });

                request->response(mids, "mids");
            }
        } else {
            macs::error_code ec;
            macs::MidList mids = metadata->envelopes().getByMessageIdWithExcluded(msgId, macs::FidVec(), yield[ec]);
            if (ec) {
                request->responseError(libwmi::error::internal, ec.message());
                return;
            }

            request->response(mids, "mids");
        }
    }
};

}
