#pragma once

#include <mail/hound/include/internal/wmi/pins.h>
#include <mail/hound/include/internal/server/handlers/messages.h>
#include <mail/hound/include/internal/wmi/yplatform/reflection/envelopes.h>

namespace hound::server::handlers {

class MessagesByThreadWithPinsHandler : public MessagesHandler {
public:
    MessagesByThreadWithPinsHandler(ConfigPtr config)
        : MessagesHandler(config) {
    }

protected:
    struct QueryParams :
            public Params::Page,
            public Params::Tid {
    };

    void executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const override {
        QueryParams params;
        if (!getQueryParams(params, *request, *metadata, yieldCtx)) {
            return;
        }
        auto yield = macs::io::make_yield_context(yieldCtx);
        const macs::Label pinnedLabel = metadata->labels().getAllLabels(yield)
                .at(macs::Label::Symbol::pinned_label);
        hound::v1::PinFactory pinFactory(*metadata, yield, pinnedLabel, params.first, params.count);
        auto pinThreadFactory = pinFactory.threadId(params.tid);

        const auto result = pinThreadFactory.get(yield);
        const std::vector<helpers::Envelope> envelopes{std::begin(result), std::end(result)};

        request->response(envelopes, "envelopes");
    }
};

}
