#pragma once

#include <mail/hound/include/internal/server/handlers/messages.h>
#include <mail/hound/include/internal/wmi/yplatform/reflection/envelopes.h>

namespace hound::server::handlers {

class MessagesUnreadHandler : public MessagesHandler {
public:
    MessagesUnreadHandler(ConfigPtr config)
        : MessagesHandler(config) {
    }

protected:
    struct QueryParams :
            public Params::Page,
            public Params::SortType {
    };

    void executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const override {
        QueryParams params;
        if (!getQueryParams(params, *request, *metadata, yieldCtx))
            return;

        auto yield = macs::io::make_yield_context(yieldCtx);
        const auto result = metadata->envelopes().query()
                .inMailbox()
                .from(params.first)
                .count(params.count)
                .sortBy(params.sortType)
                .withoutLabel(metadata->labels().getAllLabels(yield).at(macs::Label::Symbol::seen_label))
                .get(yield);

        const std::vector<helpers::Envelope> envelopes{std::begin(result), std::end(result)};

        request->response(envelopes, "envelopes");
    }
};

}
