#pragma once

#include <mail/hound/include/internal/server/handlers/macs.h>

namespace hound::server::handlers {

class Mimes : public MacsHandler {
public:
    Mimes(ConfigPtr config)
        : MacsHandler(config) {
    }

private:
    void executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const final;
    ::macs::pg::QueryHandleStrategy defaultQueryStrategy() const override {
        return ::macs::pg::readNoLagReplicaThenMasterThenReplica;
    }
    static void fillMetaPartsFromXml(macs::MidsWithMimes& mimes,
        mail_getter::MetaPartsConverterPtr converter, boost::optional<boost::asio::yield_context> yield);
    static void fillMetaPartsForInline(macs::MidsWithMimes& mimes, mail_getter::ServicePtr storageService,
        mail_getter::MetaPartsConverterPtr converter, boost::optional<boost::asio::yield_context> yield);
};

}
