#pragma once

#include <mail/hound/include/internal/server/handlers/messages.h>
#include <mail/hound/include/internal/wmi/yplatform/reflection/envelopes.h>

namespace hound::server::handlers {

class NearestMessagesHandler : public MessagesHandler {
public:
    NearestMessagesHandler(ConfigPtr config)
        : MessagesHandler(config) {
    }

protected:
    struct QueryParams :
            public Params::Mid,
            public Params::Deviation,
            public Params::SortType {
    };

    void executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const override {
        QueryParams params;
        if (!getQueryParams(params, *request, *metadata, yieldCtx)) {
            return;
        }

        auto yield = macs::io::make_yield_context(yieldCtx);
        const auto result = metadata->envelopes().query()
                .inMailbox()
                .fromMid(params.mid)
                .count(params.deviation)
                .sortBy(params.sortType)
                .get(yield);

        const std::vector<helpers::Envelope> envelopes{std::begin(result), std::end(result)};

        request->response(envelopes, "envelopes");
    }

    ::macs::pg::QueryHandleStrategy defaultQueryStrategy() const override {
        return ::macs::pg::readReplicaThenMaster;
    }
};

}
