#pragma once

#include <mail/hound/include/internal/server/base.h>

namespace hound::server::handlers {

struct Ping: public Base {
    Ping(ConfigPtr configuration)
        : Base(configuration)
    { }

    ~Ping() { }

    bool isAccepted(ymod_webserver::methods::http_method method) const override {
        return ymod_webserver::methods::mth_get == method;
    }

    void execute(ContextPtr ctx, boost::asio::yield_context) const override {
        ctx->responsePong();
    }
};

}
