#pragma once

#include <mail/hound/include/internal/server/handlers/macs.h>
#include <macs/envelopes_repository.h>

namespace hound::server::handlers {

class ResetFreshCounter : public MacsHandler {
public:
    ResetFreshCounter(ConfigPtr config)
        : MacsHandler(config) {}

private:
    void executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const final {
        auto yield = macs::io::make_yield_context(yieldCtx);
        macs::error_code ec;
        metadata->envelopes().resetFreshCounter(yield[ec]);
        if (ec) {
            request->responseError(libwmi::error::dbUnknownError, ec.message());
        } else {
            request->responseEmptyJson();
        }
    }
};

}
