#pragma once

#include <mail/hound/include/internal/server/handlers/macs.h>
#include <macs/envelopes_repository.h>

namespace hound::server::handlers {

class ResetUnvisited : public MacsHandler {
public:
    ResetUnvisited(ConfigPtr config)
        : MacsHandler(config) {}

private:
    void executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const final {
        auto yield = macs::io::make_yield_context(yieldCtx);
        std::string fid;
        if (!request->getArgument("fid", fid)) {
            request->responseError(libwmi::error::invalidArgument,
                                   "fid parameter is required");
            return;
        }

        macs::error_code ec;
        auto folders = metadata->folders().getAllFolders(yield[ec]);

        if (ec) {
            request->responseError(libwmi::error::dbUnknownError,
                                   ec.message());
            return;
        }

        const auto i = folders.find(fid);
        if (i == folders.end()) {
            request->responseError(libwmi::error::noSuchFolder,
                                   "no such folder fid=" + fid);
            return;
        }

        metadata->folders().resetUnvisited(i->second, yield[ec]);
        if (ec) {
            request->responseError(libwmi::error::dbUnknownError,
                                   ec.message());
        } else {
            request->responseEmptyJson();
        }
    }
};

}
