#pragma once

#include <mail/hound/include/internal/server/handlers/messages.h>
#include <mail/hound/include/internal/wmi/yplatform/reflection/envelopes.h>
#include <macs/threads_repository.h>

namespace hound::server::handlers {

class ThreadsByFolderHandler : public MessagesHandler {
public:
    ThreadsByFolderHandler(ConfigPtr config)
        : MessagesHandler(config) {
    }

protected:
    struct QueryParams :
            public Params::Page,
            public Params::FolderOrInbox,
            public Params::TimestampRange {
    };

    void executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const override {
        QueryParams params;
        if (!getQueryParams(params, *request, *metadata, yieldCtx))
            return;

        auto yield = macs::io::make_yield_context(yieldCtx);
        macs::EnvelopesQueryInFolder query = metadata->envelopes().query()
                .inFolder(params.folder)
                .from(params.first)
                .count(params.count)
                .groupByThreads();

        if (params.timestampRange) {
            query.withinInterval(*params.timestampRange);
        }

        const auto result = query.get(yield);
        helpers::EnvelopesAndThreadLabels res{
            .envelopes = std::vector<helpers::Envelope>{std::begin(result), std::end(result)}
        };

        std::vector<std::string> tids;
        std::transform(res.envelopes.begin(), res.envelopes.end(),
                       std::back_inserter(tids), boost::bind(&helpers::Envelope::threadId, _1));
        res.threadLabels = metadata->threads().getThreadLabels(tids, yield);

        request->response(res, "threads_by_folder");
    }
};

}
