#pragma once

#include <mail/hound/include/internal/server/handlers/messages.h>
#include <mail/hound/include/internal/wmi/yplatform/reflection/envelopes.h>
#include <macs/threads_repository.h>
#include <mail/hound/include/internal/wmi/pins.h>

namespace hound::server::handlers {

class ThreadsInFolderWithPinsHandler: public MessagesHandler {
public:
    ThreadsInFolderWithPinsHandler(ConfigPtr config)
        : MessagesHandler(config) {
    }

protected:
    struct QueryParams :
            public Params::Page,
            public Params::FolderOrInbox {
    };

    void executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const override {
        QueryParams params;
        if (!getQueryParams(params, *request, *metadata, yieldCtx)) {
            return;
        }

        auto yield = macs::io::make_yield_context(yieldCtx);
        const macs::Label pinnedLabel = metadata->labels().getAllLabels(yield)
                .at(macs::Label::Symbol::pinned_label);
        hound::v1::PinFactory pinFactory(*metadata, yield, pinnedLabel, params.first, params.count);
        auto pinThreadedFactory = pinFactory.threaded(params.folder);

        helpers::EnvelopesAndThreadLabels res;
        const auto result = pinThreadedFactory.get(yield);
        res.envelopes = std::vector<helpers::Envelope>{std::begin(result), std::end(result)};

        std::vector<std::string> tids;
        std::transform(res.envelopes.begin(), res.envelopes.end(), std::back_inserter(tids),
                       boost::bind(&helpers::Envelope::threadId, _1));
        res.threadLabels = metadata->threads().getThreadLabels(tids, yield);

        request->response(res, "threads_by_folder");
    }
};

}
