#pragma once

#include <mail/hound/include/internal/server/handlers/messages.h>
#include <mail/hound/include/internal/wmi/yplatform/reflection/envelopes.h>

namespace hound::server::handlers {

class ThreadsInfoHandler : public MessagesHandler {
public:
    ThreadsInfoHandler(ConfigPtr config)
        : MessagesHandler(config) {
    }

protected:
    struct QueryParams : public Params::Tids { };

    void executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const override {
        QueryParams params;
        if (!getQueryParams(params, *request, *metadata, yieldCtx)) {
            return;
        }

        auto yield = macs::io::make_yield_context(yieldCtx);
        helpers::EnvelopesAndThreadLabels res;
        res.threadLabels = metadata->threads().getThreadLabels(params.tids, yield);

        const auto result = metadata->envelopes().query()
                .threads(params.tids)
                .get(yield);

        res.envelopes = std::vector<helpers::Envelope>{std::begin(result), std::end(result)};

        request->response(res, "threads_info");
    }
};

}
