#pragma once

#include <mail/hound/include/internal/server/handlers/macs.h>
#include <mail/hound/include/internal/wmi/yplatform/reflection/threads_participants.h>
#include <mail/hound/include/internal/wmi/yplatform/filter_arguments.h>
#include <macs/threads_repository.h>

namespace hound::server::handlers {

class ThreadsParticipantsHandler : public MacsHandler {
public:
    ThreadsParticipantsHandler(ConfigPtr config)
        : MacsHandler(config) {
    }

protected:
    void executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const override {
        auto yield = macs::io::make_yield_context(yieldCtx);
        std::vector<std::string> tids;
        request->getArgList("tids", std::back_inserter(tids));
        filterEmptyItems(tids, request->logger, "tids", "threads");

        if (tids.empty()) {
            LOGDOG_(request->logger, notice, log::where_name = "threads",
                    log::message = "tids are not specified");
            request->response(macs::ThreadParticipantsList(), "threads");
            return;
        }


        macs::ThreadParticipantsList threadsParticipants = metadata->threads()
                .getThreadsParticipants(tids, yield);
        request->response(threadsParticipants, "threads");
    }
};

}
