#pragma once

#include <macs/database_info.h>
#include <mail/hound/include/internal/server/handlers/macs.h>
#include <mail/hound/include/internal/wmi/yplatform/reflection/database_info.h>

namespace hound::server::handlers {

class YamailStatus : public MacsHandler {
public:
    YamailStatus(ConfigPtr config)
        : MacsHandler(config) {}

private:
    void executeMacs(RequestPtr request, MailMetadataPtr, boost::asio::yield_context) const final {
        request->response(helpers::databaseInfo(macs::DatabaseState{}), "database_info");
    }

    ::macs::pg::QueryHandleStrategy defaultQueryStrategy() const override {
        return ::macs::pg::readReplicaThenMaster;
    }
};

}
