#pragma once

#include <mail/hound/include/internal/logger.h>


namespace hound {

namespace log {
LOGDOG_DEFINE_ATTRIBUTE(std::string, old_state)
LOGDOG_DEFINE_ATTRIBUTE(std::string, new_state)
LOGDOG_DEFINE_ATTRIBUTE(int, old_notifies_count)
LOGDOG_DEFINE_ATTRIBUTE(int, new_notifies_count)
LOGDOG_DEFINE_ATTRIBUTE(std::chrono::system_clock::time_point, datetime)
LOGDOG_DEFINE_ATTRIBUTE(uint64_t, uid)
LOGDOG_DEFINE_ATTRIBUTE(uint64_t, unixtime_ms)
LOGDOG_DEFINE_ATTRIBUTE(std::string, logger_name)
}

namespace internal {


inline void logUserStateChange(const uint64_t uid, const std::string& requestId, const std::string_view oldState = "frozen",
                                const std::string_view newState = "active", const int notifiesCount = 0) {
    using namespace ::hound::log;
    const auto timestamp = std::chrono::system_clock::now();
    const auto timestampMs = static_cast<uint64_t>(std::chrono::system_clock::to_time_t(timestamp)) * 1000;

    LOGDOG_(hound::getStateHistoryLogger(), notice,
        message="Updating user state",
        ::hound::log::uid=uid,
        request_id=requestId,
        old_state=oldState.data(),
        new_state=newState.data(),
        old_notifies_count=notifiesCount,
        new_notifies_count=notifiesCount,
        datetime=timestamp,
        unixtime_ms=timestampMs,
        logger_name="hound"
    );
}

}

}
